/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.dsp;

public class SimpleDelay {
    private float[] mBuffer;
    private int mCursor;

    public SimpleDelay(int length) {
        this.mBuffer = new float[length];
    }

    public float read(int position) {
        int index = this.mCursor - position;
        if (index < 0) {
            index += this.mBuffer.length;
        }
        return this.mBuffer[index];
    }

    public void write(float input) {
        this.mBuffer[this.mCursor] = input;
    }

    public void advance() {
        ++this.mCursor;
        if (this.mCursor >= this.mBuffer.length) {
            this.mCursor = 0;
        }
    }

    public float process(float input) {
        float output = this.mBuffer[this.mCursor];
        this.write(input);
        this.advance();
        return output;
    }
}

