/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.data.SequentialData;
import com.jsyn.data.SequentialDataCommon;

class SequentialDataCrossfade
extends SequentialDataCommon {
    private SequentialData source;
    private int sourceStartIndex;
    private SequentialData target;
    private int targetStartIndex;
    private int crossFadeFrames;
    private double frameScaler;

    SequentialDataCrossfade() {
    }

    public void setup(SequentialData source, int sourceStartFrame, int crossFadeFrames, SequentialData target, int targetStartFrame, int numFrames) {
        SequentialDataCrossfade crossfade;
        assert (sourceStartFrame + crossFadeFrames <= source.getNumFrames());
        assert (targetStartFrame + numFrames <= target.getNumFrames());
        if (source instanceof SequentialDataCrossfade) {
            crossfade = (SequentialDataCrossfade)source;
            if (sourceStartFrame >= crossfade.crossFadeFrames) {
                source = crossfade.target;
                sourceStartFrame += crossfade.targetStartIndex / source.getChannelsPerFrame();
            }
        }
        if (target instanceof SequentialDataCrossfade) {
            crossfade = (SequentialDataCrossfade)target;
            target = crossfade.target;
            targetStartFrame += crossfade.targetStartIndex / target.getChannelsPerFrame();
        }
        this.source = source;
        this.target = target;
        this.sourceStartIndex = sourceStartFrame * source.getChannelsPerFrame();
        this.crossFadeFrames = crossFadeFrames;
        this.targetStartIndex = targetStartFrame * target.getChannelsPerFrame();
        this.frameScaler = crossFadeFrames == 0 ? 1.0 : 1.0 / (double)crossFadeFrames;
        this.numFrames = numFrames;
    }

    @Override
    public void writeDouble(int index, double value) {
    }

    @Override
    public double readDouble(int index) {
        int frame = index / this.source.getChannelsPerFrame();
        if (frame < this.crossFadeFrames) {
            double factor = (double)frame * this.frameScaler;
            double value = (1.0 - factor) * this.source.readDouble(index + this.sourceStartIndex);
            return value += factor * this.target.readDouble(index + this.targetStartIndex);
        }
        return this.target.readDouble(index + this.targetStartIndex);
    }

    @Override
    public double getRateScaler(int index, double synthesisRate) {
        return this.target.getRateScaler(index, synthesisRate);
    }

    @Override
    public int getChannelsPerFrame() {
        return this.target.getChannelsPerFrame();
    }
}

