/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.FilterBiquad;

public abstract class FilterBiquadShelf
extends FilterBiquad {
    protected static final double MINIMUM_SLOPE = 1.0E-5;
    public UnitInputPort gain = new UnitInputPort("Gain", 1.0);
    public UnitInputPort slope;
    private double prevGain;
    private double prevSlope;
    private double beta;
    protected double alpha;
    protected double factorA;
    protected double AP1;
    protected double AM1;
    protected double beta_sn;
    protected double AP1cs;
    protected double AM1cs;

    public FilterBiquadShelf() {
        this.addPort(this.gain);
        this.slope = new UnitInputPort("Slope", 1.0);
        this.addPort(this.slope);
    }

    public abstract void updateCoefficients();

    @Override
    public void recalculate() {
        double slopeValue;
        double gainValue;
        double frequencyValue = this.frequency.getValues()[0];
        if (frequencyValue < 1.0E-5) {
            frequencyValue = 1.0E-5;
        }
        if ((gainValue = this.gain.getValues()[0]) < 1.0E-5) {
            gainValue = 1.0E-5;
        }
        if ((slopeValue = this.slope.getValues()[0]) < 1.0E-5) {
            slopeValue = 1.0E-5;
        }
        if (frequencyValue != this.previousFrequency || gainValue != this.prevGain || slopeValue != this.prevSlope) {
            this.previousFrequency = frequencyValue;
            this.prevGain = gainValue;
            this.prevSlope = slopeValue;
            double ratio = frequencyValue * this.getFramePeriod();
            this.calculateOmega(ratio);
            this.factorA = Math.sqrt(gainValue);
            this.AP1 = this.factorA + 1.0;
            this.AM1 = this.factorA - 1.0;
            double beta2 = (gainValue + 1.0) / slopeValue - this.AM1 * this.AM1;
            this.beta = beta2 < 0.0 ? 0.0 : Math.sqrt(beta2);
            this.beta_sn = this.beta * this.sin_omega;
            this.AP1cs = this.AP1 * this.cos_omega;
            this.AM1cs = this.AM1 * this.cos_omega;
            this.updateCoefficients();
        }
    }
}

