/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class LatchZeroCrossing
extends UnitGenerator {
    public UnitInputPort input = new UnitInputPort("Input");
    public UnitInputPort gate;
    public UnitOutputPort output;
    private double held;
    private boolean crossed;

    public LatchZeroCrossing() {
        this.addPort(this.input);
        this.gate = new UnitInputPort("Gate", 1.0);
        this.addPort(this.gate);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] gates = this.gate.getValues();
        double[] outputs = this.output.getValues();
        for (int i = start; i < limit; ++i) {
            double current = inputs[i];
            if (gates[i] > 0.0) {
                this.held = current;
                this.crossed = false;
            } else if (!this.crossed) {
                if (this.held * current <= 0.0) {
                    this.held = 0.0;
                    this.crossed = true;
                } else {
                    this.held = current;
                }
            }
            outputs[i] = this.held;
        }
    }
}

