/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.MixerMono;
import com.jsyn.unitgen.Unzipper;

public class MixerMonoRamped
extends MixerMono {
    private Unzipper[] unzippers;
    private Unzipper amplitudeUnzipper;

    public MixerMonoRamped(int numInputs) {
        super(numInputs);
        this.unzippers = new Unzipper[numInputs];
        for (int i = 0; i < numInputs; ++i) {
            this.unzippers[i] = new Unzipper();
        }
        this.amplitudeUnzipper = new Unzipper();
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues(0);
        double[] outputs = this.output.getValues(0);
        for (int i = start; i < limit; ++i) {
            double sum = 0.0;
            for (int n = 0; n < this.input.getNumParts(); ++n) {
                double[] inputs = this.input.getValues(n);
                double[] gains = this.gain.getValues(n);
                double smoothGain = this.unzippers[n].smooth(gains[i]);
                sum += inputs[i] * smoothGain;
            }
            outputs[i] = sum * this.amplitudeUnzipper.smooth(amplitudes[i]);
        }
    }
}

