/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitGenerator;

public class PeakFollower
extends UnitGenerator {
    public UnitInputPort input = new UnitInputPort("Input");
    public UnitVariablePort current;
    public UnitInputPort halfLife;
    public UnitOutputPort output;
    private double previousHalfLife = -1.0;
    private double decayScalar = 0.99;

    public PeakFollower() {
        this.addPort(this.input);
        this.halfLife = new UnitInputPort(1, "HalfLife", 0.1);
        this.addPort(this.halfLife);
        this.current = new UnitVariablePort("Current");
        this.addPort(this.current);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] outputs = this.output.getValues();
        double currentHalfLife = this.halfLife.getValues()[0];
        double currentValue = this.current.getValue();
        if (currentHalfLife != this.previousHalfLife) {
            this.decayScalar = this.convertHalfLifeToMultiplier(currentHalfLife);
            this.previousHalfLife = currentHalfLife;
        }
        double scalar = 1.0 - this.decayScalar;
        for (int i = start; i < limit; ++i) {
            double inputValue = inputs[i];
            if (inputValue < 0.0) {
                inputValue = -inputValue;
            }
            currentValue = inputValue >= currentValue ? inputValue : (currentValue *= scalar);
            outputs[i] = currentValue;
        }
        if (currentValue < 1.0E-26) {
            currentValue = 0.0;
        }
        this.current.setValue(currentValue);
    }
}

