/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.MultiTapDelay;
import com.jsyn.unitgen.PlateReverb;
import com.jsyn.unitgen.UnitGenerator;

public class RoomReverb
extends Circuit {
    private static final double SIZE_SCALER_MIN = 0.05;
    private static final double SIZE_SCALER_MAX = 5.0;
    private static final int[] kPositions = new int[]{10, 197, 401, 521, 733, 1117, 1481, 2731, 4177, 6073, 7927, 9463};
    private static final float[] kGains = new float[]{0.184f, -0.1543f, -0.1311f, 0.1205f, -0.1054f, -0.0859f, -0.0731f, -0.0484f, 0.0347f, 0.0254f, 0.0201f, -0.0171f};
    public UnitInputPort input;
    public UnitInputPort preDelayMillis;
    public UnitInputPort time;
    public UnitInputPort damping;
    public UnitInputPort multiTap;
    public UnitInputPort diffusion;
    public UnitOutputPort output;
    private final PlateReverb mPlateReverb;
    private final MultiTapDelay mMultiTapDelay;
    private final RoomReverbMixer mRoomReverbMixer;

    public RoomReverb() {
        this(1.0);
    }

    public RoomReverb(double size) {
        size = Math.max(0.05, Math.min(5.0, size));
        int[] positions = new int[kPositions.length];
        for (int tap = 0; tap < kPositions.length; ++tap) {
            positions[tap] = (int)((double)kPositions[tap] * size);
        }
        this.mMultiTapDelay = new MultiTapDelay(positions, kGains, (int)(4000.0 * size));
        this.add(this.mMultiTapDelay);
        this.mPlateReverb = new PlateReverb(1.0);
        this.add(this.mPlateReverb);
        this.mRoomReverbMixer = new RoomReverbMixer();
        this.add(this.mRoomReverbMixer);
        this.mMultiTapDelay.output.connect(this.mPlateReverb.input);
        this.mMultiTapDelay.output.connect(this.mRoomReverbMixer.multiTapInput);
        this.mPlateReverb.output.connect(0, this.mRoomReverbMixer.diffusionInput, 0);
        this.mPlateReverb.output.connect(1, this.mRoomReverbMixer.diffusionInput, 1);
        this.input = this.mMultiTapDelay.input;
        this.addPort(this.input);
        this.preDelayMillis = this.mMultiTapDelay.preDelayMillis;
        this.addPort(this.preDelayMillis);
        this.time = this.mPlateReverb.time;
        this.addPort(this.time);
        this.damping = this.mPlateReverb.damping;
        this.addPort(this.damping);
        this.multiTap = this.mRoomReverbMixer.multiTapGain;
        this.addPort(this.multiTap);
        this.diffusion = this.mRoomReverbMixer.diffusionGain;
        this.addPort(this.diffusion);
        this.output = this.mRoomReverbMixer.output;
        this.addPort(this.output);
    }

    static class RoomReverbMixer
    extends UnitGenerator {
        public UnitInputPort multiTapInput = new UnitInputPort("MultiTapInput");
        public UnitInputPort diffusionInput;
        public UnitInputPort multiTapGain;
        public UnitInputPort diffusionGain;
        public UnitOutputPort output;

        public RoomReverbMixer() {
            this.addPort(this.multiTapInput);
            this.diffusionInput = new UnitInputPort(2, "DiffusionInput");
            this.addPort(this.diffusionInput);
            this.multiTapGain = new UnitInputPort("MultiTap");
            this.addPort(this.multiTapGain);
            this.diffusionGain = new UnitInputPort(2, "Diffusion");
            this.addPort(this.diffusionGain);
            this.multiTapGain.setup(0.0, 1.0, 1.0);
            this.diffusionGain.setup(0.0, 1.0, 1.0);
            this.output = new UnitOutputPort(2, "Output");
            this.addPort(this.output);
        }

        @Override
        public void generate(int start, int limit) {
            double[] multiTapInputs = this.multiTapInput.getValues();
            double[] diffusionInputs0 = this.diffusionInput.getValues(0);
            double[] diffusionInputs1 = this.diffusionInput.getValues(1);
            double multiTapGainValue = this.multiTapGain.getValues()[start];
            double diffusionGainValue = this.diffusionGain.getValues()[start];
            double[] outputs0 = this.output.getValues(0);
            double[] outputs1 = this.output.getValues(1);
            for (int i = start; i < limit; ++i) {
                double multiTapScaled = multiTapInputs[i] * multiTapGainValue;
                outputs0[i] = multiTapScaled + diffusionInputs0[i] * diffusionGainValue;
                outputs1[i] = multiTapScaled + diffusionInputs1[i] * diffusionGainValue;
            }
        }
    }
}

