/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.data.FloatSample;
import com.jsyn.util.AudioSampleLoader;
import com.jsyn.util.soundfile.AIFFFileParser;
import com.jsyn.util.soundfile.AudioFileParser;
import com.jsyn.util.soundfile.IFFParser;
import com.jsyn.util.soundfile.WAVEFileParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class CustomSampleLoader
implements AudioSampleLoader {
    @Override
    public FloatSample loadFloatSample(File fileIn) throws IOException {
        FileInputStream fileStream = new FileInputStream(fileIn);
        BufferedInputStream inputStream = new BufferedInputStream(fileStream);
        return this.loadFloatSample(inputStream);
    }

    @Override
    public FloatSample loadFloatSample(URL url) throws IOException {
        InputStream rawStream = url.openStream();
        BufferedInputStream inputStream = new BufferedInputStream(rawStream);
        return this.loadFloatSample(inputStream);
    }

    @Override
    public FloatSample loadFloatSample(InputStream inputStream) throws IOException {
        AudioFileParser fileParser;
        IFFParser parser = new IFFParser(inputStream);
        parser.readHead();
        if (parser.isRIFF()) {
            fileParser = new WAVEFileParser();
        } else if (parser.isIFF()) {
            fileParser = new AIFFFileParser();
        } else {
            throw new IOException("Unsupported audio file type.");
        }
        return fileParser.load(parser);
    }
}

