/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import java.util.HashMap;
import java.util.Map;
import processing.core.PGraphics;
import processing.core.PImage;

public class ColorWheel
extends Controller<ColorWheel> {
    private int _myColorValue = -1;
    private final Map<String, PGraphics> _myColorResources;
    private final float[] _myCursor;
    private float scalar = 0.8f;
    private int yoff = 10;
    private boolean isInfo = false;
    private Label _myInfoLabel;
    private int drag = -1;
    private static final int NONE = -1;
    private static final int SATURATION = 0;
    private static final int COLOR = 1;
    private static final int ALPHA = 2;
    int _sideHandleHeight = 8;
    private double[] hsl = new double[]{1.0, 1.0, 1.0};

    public ColorWheel(ControlP5 controlP5, String string) {
        this(controlP5, (ControllerGroup<?>)controlP5.getDefaultTab(), string, 0, 0, autoWidth, autoHeight);
        controlP5.register(controlP5.papplet, string, this);
    }

    public ColorWheel(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myColorResources = new HashMap<String, PGraphics>();
        this._myColorResources.put("default", this.cp5.papplet.createGraphics(n3, n4));
        this._myCursor = new float[]{this.getWidth() / 2, this.getHeight() / 2};
        this._myCaptionLabel.align(37, 13);
        this._myCaptionLabel.setPaddingX(0);
        this._myInfoLabel = new Label(this.cp5, string + "-info");
        this._myInfoLabel.setPaddingX((int)4).getStyle().marginTop = 4;
        this.yoff = (int)((double)this.getWidth() * 0.05);
        this.setColorResources();
    }

    @Override
    public void onStartDrag() {
        this.checkDrag();
    }

    private void checkDrag() {
        double d = this.getPointer().x();
        double d2 = this.getPointer().y() + this.yoff;
        double d3 = this.getWidth() / 2;
        double d4 = this.getHeight() / 2;
        double d5 = (float)(this.getWidth() / 2) * this.scalar + 1.0f;
        double d6 = Math.sqrt(Math.pow(d - d3, 2.0) + Math.pow(d2 - d4, 2.0));
        double d7 = ((double)this.getWidth() - d5 * 2.0) / 2.0;
        this.drag = -1;
        if (d6 <= d5) {
            this.drag = 1;
        } else if (d >= 0.0 && d <= d7) {
            this.drag = 0;
        } else if (d >= (double)this.getWidth() - d7 && d <= (double)this.getWidth()) {
            this.drag = 2;
        }
    }

    @Override
    public void onEndDrag() {
        this.drag = -1;
    }

    @Override
    public void onDrag() {
        switch (this.drag) {
            case 1: {
                double d = this.getPointer().x();
                double d2 = this.getPointer().y() + this.yoff;
                double d3 = this.getWidth() / 2;
                double d4 = this.getHeight() / 2;
                double d5 = Math.atan2(d2 - d4, d - d3);
                double d6 = (double)this.getWidth() * 0.1;
                double d7 = (float)(this.getWidth() / 2) * this.scalar + 1.0f;
                double d8 = Math.sqrt(Math.pow(d - d3, 2.0) + Math.pow(d2 - d4, 2.0));
                if (d8 >= d7 - 1.0) {
                    d = d3 + Math.cos(d5) * d7;
                    d2 = d4 + Math.sin(d5) * d7;
                } else if (d8 <= d6) {
                    d = d3 + Math.cos(d5) * d6;
                    d2 = d4 + Math.sin(d5) * d6;
                }
                ColorWheel.set(this._myCursor, (float)d, (float)d2);
                int n = (int)d;
                int n2 = (int)d2;
                double[] dArray = this.RGBtoHSL(this._myColorResources.get("default").get(n, n2));
                this.hsl[0] = dArray[0];
                this.hsl[2] = dArray[2];
                this._myColorValue = this.HSLtoRGB(this.hsl);
                this.setValue(this._myColorValue);
                break;
            }
            case 0: {
                float f = this.getHeight() - this.yoff * 2 - this._sideHandleHeight;
                this.setSaturation(this.map(this.getPointer().y(), 0.0, f, 1.0, 0.0));
                this._myColorValue = this.HSLtoRGB(this.hsl);
                this.setValue(this._myColorValue);
                break;
            }
            case 2: {
                float f = this.getHeight() - this.yoff * 2 - this._sideHandleHeight;
                this.setAlpha((int)this.map(this.getPointer().y(), 0.0, f, 255.0, 0.0));
                this._myColorValue = this.HSLtoRGB(this.hsl);
                this.setValue(this._myColorValue);
            }
        }
    }

    @Override
    public void onPress() {
        this.checkDrag();
    }

    @Override
    public void onRelease() {
        this.onDrag();
    }

    public ColorWheel scrolled(int n) {
        if (this.isVisible) {
            double d = this.getPointer().x();
            double d2 = (float)(this.getWidth() / 2) * this.scalar + 1.0f;
            double d3 = ((double)this.getWidth() - d2 * 2.0) / 2.0;
            if (d >= 0.0 && d <= d3) {
                this.setSaturation(this.hsl[1] + (double)n * 0.01);
                this._myColorValue = this.HSLtoRGB(this.hsl);
                this.setValue(this._myColorValue);
            } else if (d >= (double)this.getWidth() - d3 && d <= (double)this.getWidth()) {
                this.setAlpha(this.a() + n);
            }
        }
        return this;
    }

    private void setColorResources() {
        PGraphics pGraphics = this._myColorResources.get("default");
        pGraphics.beginDraw();
        pGraphics.background(0, 0.0f);
        int n = pGraphics.width;
        int n2 = pGraphics.height;
        float[] fArray = new float[]{n / 2, n2 / 2};
        int n3 = (int)((double)pGraphics.width * 0.1);
        int n4 = (int)((float)pGraphics.width * this.scalar / 2.0f);
        pGraphics.fill(0);
        pGraphics.ellipseMode(3);
        pGraphics.ellipse((float)(pGraphics.width / 2), (float)(pGraphics.height / 2), (float)pGraphics.width * this.scalar + 4.0f, (float)pGraphics.width * this.scalar + 4.0f);
        pGraphics.fill(255);
        pGraphics.ellipse((float)(pGraphics.width / 2), (float)(pGraphics.height / 2), (float)((n3 + 1) * 2), (float)((n3 + 1) * 2));
        for (int i = 0; i < n2; ++i) {
            int n5 = (int)(ColorWheel.y(fArray) - (float)i);
            for (int j = 0; j < n; ++j) {
                double d;
                double d2;
                int n6 = (int)(ColorWheel.x(fArray) - (float)j);
                double d3 = Math.sqrt(n6 * n6 + n5 * n5);
                if (!(d3 >= (double)n3) || !(d3 <= (double)n4)) continue;
                double d4 = Math.atan2(n5, n6);
                double d5 = (d4 + 3.1415927410125732) / 6.2831854820251465;
                if (d3 < (double)(n3 + (n4 - n3) / 2)) {
                    d2 = this.map(d3, n3, n4, 0.0, 2.0);
                    d = 1.0;
                } else {
                    d2 = 1.0;
                    d = this.map(d3, n3, n4, 2.0, 0.0);
                }
                pGraphics.set(j, i, this.HSVtoRGB(d5, d2, d));
            }
        }
        pGraphics.endDraw();
    }

    public void setHue(double d) {
        this.hsl[0] = Math.max(0.0, Math.min(1.0, d));
    }

    public void setSaturation(double d) {
        this.hsl[1] = Math.max(0.0, Math.min(1.0, d));
    }

    public void setLightness(double d) {
        this.hsl[2] = Math.max(0.0, Math.min(1.0, d));
    }

    public ColorWheel setHSL(double d, double d2, double d3) {
        this.setHue(d);
        this.setSaturation(d2);
        this.setLightness(d3);
        return this;
    }

    public int getRGB() {
        return this._myColorValue;
    }

    public ColorWheel setRGB(int n) {
        double[] dArray = this.RGBtoHSL(n);
        this.hsl[0] = dArray[0];
        this.hsl[2] = dArray[2];
        float f = (float)(dArray[0] * 6.2831854820251465) - (float)Math.PI;
        float f2 = (float)this.getWidth() * 0.1f;
        float f3 = (float)(this.getWidth() / 2) * this.scalar + 1.0f;
        float f4 = (float)this.map(dArray[2], 0.0, 1.0, f3, f2);
        float f5 = (float)(this._myColorResources.get((Object)"default").width / 2) - (float)Math.cos(f) * f4;
        float f6 = (float)(this._myColorResources.get((Object)"default").height / 2) - (float)Math.sin(f) * f4;
        ColorWheel.set(this._myCursor, f5, f6);
        this.setSaturation(dArray[1]);
        this._myColorValue = this.HSLtoRGB(this.hsl);
        this.setValue(this._myColorValue);
        return this;
    }

    public ColorWheel setAlpha(int n) {
        return this;
    }

    @Override
    @ControlP5.Invisible
    public ColorWheel updateDisplayMode(int n) {
        return this.updateViewMode(n);
    }

    @ControlP5.Invisible
    public ColorWheel updateViewMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                this._myControllerView = new ColorWheelView();
            }
        }
        return this;
    }

    public int a() {
        int n = (this._myColorValue & 0xFF000000) >> 24;
        return n < 0 ? 255 : n;
    }

    public int r() {
        return (this._myColorValue & 0xFF0000) >> 16;
    }

    public int g() {
        return (this._myColorValue & 0xFF00) >> 8;
    }

    public int b() {
        return (this._myColorValue & 0xFF) >> 0;
    }

    public double[] RGBtoHSL(int n) {
        return this.RGBtoHSL(n >> 16 & 0xFF, n >> 8 & 0xFF, n >> 0 & 0xFF);
    }

    public double[] RGBtoHSL(int n, int n2, int n3) {
        double[] dArray = new double[]{(double)n / 255.0, (double)n2 / 255.0, (double)n3 / 255.0};
        double d = Math.max(dArray[0], Math.max(dArray[1], dArray[2]));
        double d2 = Math.min(dArray[0], Math.min(dArray[1], dArray[2]));
        double d3 = (d + d2) / 2.0;
        double d4 = (d + d2) / 2.0;
        double d5 = (d + d2) / 2.0;
        if (d == d2) {
            d4 = 0.0;
            d3 = 0.0;
        } else {
            double d6 = d - d2;
            double d7 = d4 = d5 > 0.5 ? d6 / (2.0 - d - d2) : d6 / (d + d2);
            if (d == dArray[0]) {
                d3 = (dArray[1] - dArray[2]) / d6 + (double)(dArray[1] < dArray[2] ? 6 : 0);
            } else if (d == dArray[1]) {
                d3 = (dArray[2] - dArray[0]) / d6 + 2.0;
            } else if (d == dArray[2]) {
                d3 = (dArray[0] - dArray[1]) / d6 + 4.0;
            }
            d3 /= 6.0;
        }
        return new double[]{d3, d4, d5};
    }

    public int HSVtoRGB(double[] dArray) {
        return this.HSVtoRGB(dArray[0], dArray[1], dArray[2]);
    }

    public int HSVtoRGB(double d, double d2, double d3) {
        double[] dArray = new double[3];
        if (d == 1.0) {
            d = 0.0;
        }
        double d4 = 0.16666666666666666;
        double d5 = d / d4;
        int n = (int)Math.floor(d5);
        double d6 = d5 - (double)n;
        double d7 = d3 * (1.0 - d2);
        double d8 = d3 * (1.0 - d2 * d6);
        double d9 = d3 * (1.0 - d2 * (1.0 - d6));
        switch (n) {
            case 0: {
                dArray[0] = d3;
                dArray[1] = d9;
                dArray[2] = d7;
                break;
            }
            case 1: {
                dArray[0] = d8;
                dArray[1] = d3;
                dArray[2] = d7;
                break;
            }
            case 2: {
                dArray[0] = d7;
                dArray[1] = d3;
                dArray[2] = d9;
                break;
            }
            case 3: {
                dArray[0] = d7;
                dArray[1] = d8;
                dArray[2] = d3;
                break;
            }
            case 4: {
                dArray[0] = d9;
                dArray[1] = d7;
                dArray[2] = d3;
                break;
            }
            case 5: {
                dArray[0] = d3;
                dArray[1] = d7;
                dArray[2] = d8;
                break;
            }
            default: {
                System.out.println("hsv to rgb not possible");
            }
        }
        return this.a() << 24 | (int)(dArray[0] * 255.0) << 16 | (int)(dArray[1] * 255.0) << 8 | (int)(dArray[2] * 255.0);
    }

    public final double[] RGBtoHSV(int n) {
        return this.RGBtoHSV((n & 0xFF0000) >> 16, (n & 0xFF00) >> 8, (n & 0xFF) >> 0);
    }

    public final double[] RGBtoHSV(int n, int n2, double d) {
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = (double)n / 255.0;
        double d8 = (double)n2 / 255.0;
        double d9 = d / 255.0;
        double d10 = Math.min(d7, Math.min(d8, d9));
        if (d10 == (d3 = Math.max(d7, Math.max(d8, d9)))) {
            return new double[]{0.0, 0.0, d10};
        }
        double d11 = d7 == d10 ? d8 - d9 : (d2 = d9 == d10 ? d7 - d8 : d9 - d7);
        double d12 = d7 == d10 ? 3.0 : (double)(d9 == d10 ? 1 : 5);
        d4 = this.map(d12 - d2 / (d3 - d10), 0.0, 6.0, 0.0, 1.0);
        d5 = (d3 - d10) / d3;
        d6 = d3;
        return new double[]{d4, d5, d6};
    }

    public int HSLtoRGB(double[] dArray) {
        if (dArray.length == 3) {
            return this.HSLtoRGB(dArray[0], dArray[1], dArray[2]);
        }
        String string = "HSLtoRGB(double[]) a length of 3 is expected. ";
        throw new IllegalArgumentException(string);
    }

    public int HSLtoRGB(double d, double d2, double d3) {
        if (d < 0.0 || d > 1.0) {
            String string = "Color parameter outside of expected range - Hue ( 0.0 - 1.0 )";
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            String string = "Color parameter outside of expected range - Saturation ( 0.0 - 1.0 )";
            throw new IllegalArgumentException(string);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            String string = "Color parameter outside of expected range - Luminance ( 0.0 - 1.0 )";
            throw new IllegalArgumentException(string);
        }
        double d4 = 0.0;
        d4 = d3 < 0.5 ? d3 * (1.0 + d2) : d3 + d2 - d2 * d3;
        double d5 = 2.0 * d3 - d4;
        double d6 = Math.max(0.0, ColorWheel.HueToRGB(d5, d4, d + 0.3333333432674408));
        double d7 = Math.max(0.0, ColorWheel.HueToRGB(d5, d4, d));
        double d8 = Math.max(0.0, ColorWheel.HueToRGB(d5, d4, d - 0.3333333432674408));
        return 0xFF000000 | (int)(d6 * 255.0) << 16 | (int)(d7 * 255.0) << 8 | (int)(d8 * 255.0);
    }

    private static double HueToRGB(double d, double d2, double d3) {
        if (d3 < 0.0) {
            d3 += 1.0;
        }
        if (d3 > 1.0) {
            d3 -= 1.0;
        }
        if (6.0 * d3 < 1.0) {
            return d + (d2 - d) * 6.0 * d3;
        }
        if (2.0 * d3 < 1.0) {
            return d2;
        }
        if (3.0 * d3 < 2.0) {
            return d + (d2 - d) * 6.0 * (0.6666666865348816 - d3);
        }
        return d;
    }

    private final double map(double d, double d2, double d3, double d4, double d5) {
        return d4 + (d5 - d4) * ((d - d2) / (d3 - d2));
    }

    private class ColorWheelView
    implements ControllerView<ColorWheel> {
        private ColorWheelView() {
        }

        @Override
        public void display(PGraphics pGraphics, ColorWheel colorWheel) {
            PGraphics pGraphics2 = (PGraphics)ColorWheel.this._myColorResources.get("default");
            pGraphics.fill(0, 100.0f);
            pGraphics.rect(0.0f, 0.0f, (float)ColorWheel.this.getWidth(), (float)ColorWheel.this.getHeight());
            pGraphics.ellipseMode(3);
            pGraphics.pushMatrix();
            pGraphics.translate(0.0f, (float)(-ColorWheel.this.yoff));
            pGraphics.image((PImage)pGraphics2, 0.0f, 0.0f);
            pGraphics.pushMatrix();
            pGraphics.translate(Controller.x(ColorWheel.this._myCursor), Controller.y(ColorWheel.this._myCursor));
            pGraphics.strokeWeight(2.0f);
            pGraphics.noFill();
            pGraphics.stroke(255, 40.0f);
            pGraphics.ellipse(1.0f, 1.0f, 10.0f, 10.0f);
            pGraphics.stroke(250);
            pGraphics.fill(ColorWheel.this._myColorValue);
            pGraphics.ellipse(0.0f, 0.0f, 10.0f, 10.0f);
            pGraphics.popMatrix();
            pGraphics.noStroke();
            pGraphics.translate(0.0f, (float)(-ColorWheel.this.yoff));
            pGraphics.fill(ColorWheel.this.HSLtoRGB(ColorWheel.this.hsl[0], ColorWheel.this.hsl[1], ColorWheel.this.hsl[2]));
            pGraphics.rect(0.0f, (float)ColorWheel.this.getHeight(), (float)ColorWheel.this.getWidth(), (float)(ColorWheel.this.yoff * 2));
            pGraphics.popMatrix();
            if (ColorWheel.this.isLabelVisible) {
                ColorWheel.this._myCaptionLabel.draw(pGraphics, 0, 0, colorWheel);
            }
            if (ColorWheel.this.isInfo) {
                ColorWheel.this._myInfoLabel.setText(String.format("RGB %d %d %d\nALPHA %d\nHSL %d %.2f %.2f ", ColorWheel.this.r(), ColorWheel.this.g(), ColorWheel.this.b(), ColorWheel.this.a(), (int)(ColorWheel.this.hsl[0] * 360.0), ColorWheel.this.hsl[1], ColorWheel.this.hsl[2]));
                ColorWheel.this._myInfoLabel.draw(pGraphics, 0, 0, colorWheel);
            }
            pGraphics.fill(255);
            pGraphics.pushMatrix();
            int n = ColorWheel.this._sideHandleHeight / 2;
            float f = ColorWheel.this.getHeight() - ColorWheel.this.yoff * 2 - ColorWheel.this._sideHandleHeight;
            pGraphics.translate(2.0f, (float)((int)ColorWheel.this.map(ColorWheel.this.hsl[1], 1.0, 0.0, 0.0, f)));
            pGraphics.triangle(0.0f, (float)n, (float)n, 0.0f, (float)n, (float)ColorWheel.this._sideHandleHeight);
            pGraphics.popMatrix();
        }
    }
}

