/* autogenerated by Processing revision 1293 on 2024-05-21 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import processing.net.*;
import processing.sound.*;
import controlP5.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class aprsClient extends PApplet {

/*
 ok, restart project
 
 we're going to use stringlists and that's that. screw arrays and arraylists
 - update i will probably use an ArrayList of objects :(
 
 in fact, what i *should* do is class by call-id/mode and make a list for each
 - maybe?
 
 eg
 VA3APW-1 T
 VA3APW-1 !
 in seperate lists
 
 OR
 
 i can just search through the history for the relevant entries (i like this)
 - like making a .csv better and using a spreadsheet
 
 
 */




ControlP5 cp5;
//Textarea myTextarea;

// globals
String version;
Client sock;
SinOsc snd;
SoundFile snd_file;
SoundFile meow;

int historyMax = 16383;
boolean CONNECTED = false;
String cr ="\r";
String lf ="\n";
String crlf = "\r\n";
int currentBcnPos = 0;

PImage loc_img;
PImage spkr_img;

String mybeacon = "VA3ODC D-Star/APRS - aprs-j ver0.01";
//Button but;
Button but = new Button(150, 40, "BEACON", color(255, 255, 0), color(25, 25, 150), 18);
Button select = new Button(150, 40, "Next->", color(255, 255, 0), color(25, 25, 150), 18);
Button edFavorites = new Button(100, 40, "Faves", color(255, 255, 0), color(25, 25, 150), 18);
Button edSetup = new Button(100, 40, "Setup", color(255, 255, 0), color(25, 25, 150), 18);
Button edBeacons = new Button(100, 40, "Beacons", color(255, 255, 0), color(25, 25, 150), 18);

Button butSaveHistory = new Button(100, 40, "Save H", color(255, 255, 0), color(25, 25, 150), 18);
Button butClearHistory = new Button(100, 40, "Clear H", color(255, 255, 0), color(25, 25, 150), 18);

class MyStuff {
  //server et al stuff
  String callsign;
  String id;
  String pass;
  String login;
  String filter;
  // position (aprs_text and decimal - you do the math)
  String lat;
  String lon;
  float latD;
  float lonD;
  // beaconing info (seperate from beacons.txt)
  String beacon;
  int bcnTimeout;

  String symbol;
  String sL, sR;
}
MyStuff my = new MyStuff();

String lastBeacon = "";
String nextBeacon = "";

StringList history = new StringList();
StringList favourites = new StringList();
StringList lastFav = new StringList();

StringList beacons = new StringList();

//AprsObject packet = new AprsObject("");

AprsObject current = new AprsObject("MARTEN");
AprsObject[] last = new AprsObject[6];
AprsObject[] temp = new AprsObject[7];


//ArrayList<AprsObject> records = new ArrayList<AprsObject>();

String url1, url2;

PFont font;

public void setup() {
  //windowResizable(true);
  //frame.setResizable(true);
  //surface.setResizable(true);

  /* size commented out by preprocessor */;
  background(0, 0, 30);
  
  PFont font;
  font = createFont("Courier New", 14);
  textFont(font, 16);

  //--------------------------------------------------------------------------------------------------------------
  cp5 = new ControlP5(this);
  cp5.addTextfield("callsign").setPosition(80, 290).setSize(90, 30).setFont(font).setAutoClear(false);
  cp5.addTextfield("message").setPosition(180, 290).setSize(250, 30).setFont(font).setAutoClear(false);
  cp5.addBang("Send").setPosition(450, 290).setSize(60, 30);

  history = new StringList();
  favourites = new StringList();
  // ok, here we go
  background(0);
  fill(255);
  textSize(48);
  text("loading user...", 300, width/2);
  loadUserParams();
  background(0);
  text("loading favourites...", 300, width/2);
  my.beacon = my.callsign + "-" + my.id + ">APMI06,TCPIP*,qAS," + my.callsign + ":=" +my.lat + my.sL + my.lon + my.sR;

  loadFavourites();
  background(0);
  text("loading beacons...", 300, width/2);
  loadBeacons();


  snd = new SinOsc(this);
  snd_file = new SoundFile(this, "dun-dun.mp3");
  snd_file.amp(0.5f);
  meow = new SoundFile(this, "meow.mp3");
  meow.amp(0.3f);


  textSize(16);

  // last N history objects
  for (int k=0; k < last.length; k++) {
    last[k] = new AprsObject("hello " + k);
    last[k].update("N1KK0-10>path:>status");
    last[k].x = 700;
    last[k].y = (k-1) * 200+20;
  }

  // last 4 history objects
  for (int m=0; m < 5; m++) {
    temp[m] = new AprsObject("hello " + m);
    temp[m].update("MARTEN-10>path:>cool status");
    temp[m].x = 700;
    temp[m].y = (m-1) * 200 +20;
  }

  current.update("NIKKO>pathway:>status");

  loc_img = loadImage("location-80.png");
  spkr_img = loadImage("speaker.png");

  nextBeacon = beacons.get(PApplet.parseInt(random(beacons.size())));

  fill(255);
  textSize(48);
  background(0);
  text("connecting...", 200, 600);

  // ------------ do it!
  sockConnect();
  // ------------

  //
}

public void Send() {
  print("the following text was submitted :");
  url1 = cp5.get(Textfield.class, "callsign").getText();
  url2 = cp5.get(Textfield.class, "message").getText();

  sendMessage(url1, url2);
}

public void showRecord(AprsObject rec) {
  rec.show();
}

public void draw() {
  //background(30, 0, 0);
  String data;
  snd.stop();
  current.show();
  
  if (CONNECTED) {
    showTime();
    current.show();
    // get a string
    if (sock.available() > 0) { // If there's incoming data from the client...
      data = sock.readString(); // grab it and append to history (eventually)
      if (data.indexOf("#") == 0) return;  // server message - ignore

      // split into sep strings
      String[] t = split(data, crlf);

      // loop through all the incoming in case there's a burst (which are many)
      // MAIN LOOP
      for (int i=0; i<t.length; i++) if (t[i].length() >0) {
        // do for all
        AprsObject packet = new AprsObject(t[i]);
        packet.update(t[i]);
        
        // might work? (does)
        current = packet;
        
        // update winTitle
        windowTitle(packet.callsign);

        // print current time
        showTime();

        // update history
        history.append(timestamp() + " " + t[i]);

        // display incoming packet
        packet.x = 30;
        packet.y = 20;
        packet.show();

        // see if it's in the list
        if (inList(parseCall(t[i]))) {
          showTime();

          // if it's in the callsign watch list...
          packet.update(t[i]);
          packet.x = 30;
          packet.y = 20;
          packet.show();

          // bump them
          for (int j=last.length-2; j>=0; j--) last[j+1] = last[j];
          last[0] = packet;
          
        }
        // not in list show anyway
        packet.x = 30;
        packet.y = 20;
        packet.show();
        showTime();

      }
    }
  }

  // clear screen - draw everything
  background(30, 0, 0);
  
  // print something as a place holder
  textSize(40);
  text("va3odc.com",100,80);
  
  printHistory();
  
  current.show();
  
  // show the last N matching packets :)
  for (int k=0; k<last.length; k++) {
    last[k].x = 700;
    last[k].y = k*last[k].h;
    last[k].show();
  }

  showButtons();

  select.show(30, 160);
  // print nextBeacon
  fill(170);
  text(nextBeacon, 200, 190);
  // beacon button
  but.show(30, 205);
  // print lastBeacos
  fill(170);
  text("last bcn: " + lastBeacon, 30, 275);

  text("msg: ", 30, 310);
  
  // ------------------------------------------------------------------------------------------------------------------------------
  // print current time
  showTime();
}
  
public void showButtons() {
  edFavorites.show(30, 660);
  edBeacons.show(150, 660);
  edSetup.show(270, 660);
  butSaveHistory.show(390, 660);
  butClearHistory.show(510, 660);
  
  textSize(14);
  fill(150, 150, 10);
  text("changes require restart!", 110, 718);
}

//void mouseMoved() {
//  showButtons();
//}

public void mouseClicked() {
  if (but.hover()) beaconNow("");
  if (select.hover()) randomBeaconSelect();
  if (edFavorites.hover()) openNotepad("callsigns.txt");
  if (edBeacons.hover()) openNotepad("beacons.txt");
  if (edSetup.hover()) openNotepad("setup.txt");

  if (butClearHistory.hover()) history.clear();
  if (butSaveHistory.hover()) { 
    String[] stringArray = history.toArray(new String[history.size()]);
    saveStrings("history.txt",stringArray);
    history.append("-------- ===== >> DATA SAVED in history.txt << ======= ---------");
  }
  
}

public void openNotepad(String filename) {
  // open notepad.exe with filename.txt
  String callFile = sketchPath() + "/" + filename;
  String a = "notepad.exe " + callFile;
  launch(a);
}

public void randomBeaconSelect() {
  currentBcnPos++;
  if(currentBcnPos > beacons.size()-1) currentBcnPos = 0;
  //nextBeacon = beacons.get(int(random(beacons.size())));
  nextBeacon = beacons.get(currentBcnPos);
}

public String timestamp() {
  return nf(hour(), 2) +":"+ nf(minute(), 2) +":"+ nf(second(), 2) + " ";
}

public void showTime() {
  fill(60);
  rect(520, 85, 120, 20);
  fill(255);
  textSize(20);
  text(timestamp(), 530, 100);
}

public void loadUserParams() {
  // get info saved in setup.txt
  String[] lines = loadStrings("setup.txt");
  my.callsign = lines[0];
  my.id = lines[1];
  my.pass = lines[2];
  my.filter = lines[3];
  my.bcnTimeout =PApplet.parseInt(lines[4]);
  my.lat = lines[5];
  my.lon = lines[6];
  my.latD = PApplet.parseFloat(lines[7]);
  my.lonD = PApplet.parseFloat(lines[8]);
  my.symbol = lines[9];
  my.sL = my.symbol.substring(0, 1);
  my.sR = my.symbol.substring(1, 2);
  my.login = "user " + my.callsign + "-" + my.id + " pass " + my.pass + " ver APRSdashboard 0.04 filter " + my.filter;


  //println(lines.length, "user params loaded.");
}

public void loadFavourites() {
  // get the favourites from callsigns.txt
  String[] lines = loadStrings("callsigns.txt");
  favourites.clear();
  for (int i = 0; i < lines.length; i++) {
    favourites.append(lines[i]);
  }
  //println(lines.length, "favourites loaded.");
}

public void loadBeacons() {
  // get the beacons from beacons.txt
  //beacons.clear();
  String[] lines = loadStrings("beacons.txt");
  //println("# lines= ", lines.length);
  for (int i = 0; i < lines.length; i++) {
    //println(i, lines[i]);
    beacons.append(lines[i]);
  }
  //println(lines.length, "beacons loaded.");
}

public boolean inList(String call) {
  // loop through favourites
  if (call != null) {
    for (int i=0; i < favourites.size(); i++) {
      String g = favourites.get(i);
      if (call.contains(g)) return true;
    }
  }
  return false;
}


public void sockConnect() {
  // Connect to APRS server on port 14580
  sock = new Client(this, "euro.aprs2.net", 14580);
  // send this to IS to get started
  sock.write(my.login + crlf);
  // we'll assume it worked out... lol
  CONNECTED = true;
}

public void printHistory() {
  //int m=0;if(m == 0) return;
  StringList temp;
  temp = new StringList();
  int hsize = history.size();

  // get the last # lines depending on screen height
  int numlines = 20; //height/20-3;
  if (hsize<numlines) numlines = hsize;

  // get them from history backwards
  //println("hsize",hsize,"history.size()",history.size());
  for (int i=hsize-1; i>=hsize-numlines; i--) temp.append(history.get(i));

  fill(255, 255, 0);
  textSize(20);
  text("history " + history.size(), 20, 380);
  textSize(12);

  // show them
  pushMatrix();
  translate(10, 400);
  float fadespeed = 15;
  String dt;
  for (int k=0; k<temp.size(); k++) {
    dt = temp.get(k);
    fill(250- k*fadespeed);
    if (inList(parseCall(dt))) {
      fill(0, 255, 0);
    }
    text(dt, 0, 18*k);
  }
  fill(0);
  popMatrix();
  
  if (hsize >= historyMax) history.remove(0);

}

public String parseCall(String d) {
  String[] arr = split(d, '>');
  String H = arr[0];
  return H;
}

public void sendMessage(String call, String msg) {
  println("Beacon", call, msg);

  if (CONNECTED) {
    if(call.length() < 4) return;
    if(msg.length() < 1) msg = "<->";
    String cs = call.toUpperCase();
    String bacon = my.callsign + "-" + my.id + ">APMI06,TCPIP*,qAS," + my.callsign + "::";
    cs = cs + "          ";
    cs = cs.substring(0, 9);
    String ack = "{" + str(PApplet.parseInt(random(10000, 99999)));
    bacon = bacon + cs + ":" + msg + ack;

    sock.write(bacon + crlf);
  }
}


public void beaconNow(String txt) {
  String bcn;
  if (CONNECTED) {
    if (nextBeacon.length() < 1) bcn = beacons.get(PApplet.parseInt(random(beacons.size())));

    // my.beacon = my.callsign + "-" + my.id + ">APMI06,TCPIP*,qAS," + my.callsign + ":=" +my.lat + my.sL + my.lon + my.sR;

    bcn = nextBeacon;
    sock.write(my.beacon + bcn + crlf);

    lastBeacon = timestamp() + " " + bcn;
    //nextBeacon = beacons.get(int(random(beacons.size())));
  }
}


////

////

//

/*

arrrg, matey

we have to do this :(

info we'll need to get/save - a LONG list no doubt
// comment line

// user and login information
_USERINFO
callsign:
id:
etc:

// server info
_SERVER_INFO 
server: noam.aprs2.net
port: 14580

_FAVOURITES
// call, mode, 
// eg
VA3APW-3, T, 
VA3APW-2, #,
VA3APW-1, !,

//--------------------------------------------------

class MyStuff {
  //server et al stuff
  String callsign;
  String id;
  String pass;
  String login;
  String filter;
  // position (aprs_text and decimal - you do the math)
  String lat;
  String lon;
  float latD;
  float lonD;
  // beaconing info (seperate from beacons.txt)
  String beacon;
  int bcnTimeout;

  String symbol;
  String sL, sR;
}
MyStuff my = new MyStuff();



*/


/*
  a window shall have:
 - moveable
 - titlebar
 - title
 - z-order
 - inArea(mouseX,mouseY) for instance (checks on mousepressed)
 - colour
 - text fields?
 
 
 */

/*
class Panel {
 // Panel panel = new Panel();
 //
 // a Panal can contain:
 //
 // - buttons
 // - boxes (for text)
 }
 
 class SewingBox {
 // container for Buttons
 int num;
 int x, y, w, h;
 color bordercolor;
 color backcolor;
 boolean moveable;
 
 Button[] buts;
 
 // this goes some where...
 // Button[] buts = new Button[2];
 
 SewingBox(Button[] arrButtonObjects) {
 // initialize stuff here on first instciation
 }
 
 void update() {
 }
 
 void show() {
 // run throug the button arr and display them
 // pushMatrix();
 // translate(x, y);
 // in fact, we could translate to or set an offset for each button
 // do stuffs...
 // popMatrix();
 }
 
 void butonAdd(Button obj) {
 }
 
 void buttonRemove(int buttonIndex) {
 }
 }
 */


//------------------------------------------------------------------------------------------
class Button {
  // not sure i even need to do this - may make them static or some other issue - wtf knows
  // i think it does make them static for the class
  // but can hopefully over-ride them
  int x=0;
  int y=0;
  int w=100;
  int h=40;
  String caption = "ADD watch";
  int fcolor;
  int bcolor;
  int txtsize = 18;

  boolean hovering = false;
  boolean dragging = false;

  Button(int w, int h, String caption, int fcolor, int bcolor, int txtsize) {
    //println(w, h, caption, fcolor, bcolor, txtsize);
    this.w = w;
    this.h = h;
    this.caption = caption;
    this.fcolor = fcolor;
    this.bcolor = bcolor;
    this.txtsize = txtsize;
  }

  public void show(float xx, float yy) {
    // x,y are essentially the offset position that the calling routine sets
    x = PApplet.parseInt(xx);
    y = PApplet.parseInt(yy);

    //noStroke();
    if (this.hover()) {
      fill(255);
      rect(x+2, y+2, w, h);
    }
    // display button
    fill(bcolor);
    rect(x, y, w, h);
    //noStroke();

    fill(fcolor);
    textSize(txtsize);
    textAlign(CENTER, CENTER);
    text(caption, x+(w/2), y+(h/2));
    textAlign(LEFT);
  }

  public boolean hover() {
    //return (mouseX > x && mouseX < x + w && mouseY > y && mouseY < y + h);
    boolean test = (mouseX > x && mouseX < x + w && mouseY > y && mouseY < y + h);
    //hovering = false;
    //if(test) hovering = true;
    return test;
    //return (mouseX > x && mouseX < x + w && mouseY > y && mouseY < y + h);
  }
}

/*

 class Theme {
 Theme(String[] arg) {
 // like, background/fore clrs
 // Z value stuff
 }
 }
 */

/*

 oh boy!
 
 */


class AprsObject {
  String callsign, id, path, mode, tail, symL, symR, lat, lon, status, msgtext;
  float latD, lonD, bearing, distance;
  String telemetry;
  String tstamp;
  String tag;

  int x, y;
  int w = 450;
  int h = 120;

  String display;

  int titleBack, titleFore, bodyBack, bodyFore, brdrColour, shadowColour;
  ;
  int clr = color(100, 26, 179);

  /*+-------------------___________----------------------===========+*/

  AprsObject(String t) {
    //data = arg;
    String txt = t;
    //makeRecord(t);
    brdrColour = color(144);
    brdrColour = color(0);
    bodyBack = color(0);
    bodyFore = color(255);
    titleBack = color(60, 70, 80);
    titleFore = color(255, 255, 255);
    shadowColour = color(60, 70, 80, 100);
    display = "ve3ugg.com catsrus.ca";
  }

  public void update(String aprsStringFormat) {
    // the meat and potatoes
    // arrgg...

    //reset all the variables
    callsign ="";
    id="";
    path="";
    mode="";
    tail="";
    symL="";
    symR="";
    lat="";
    lon="";
    status="";
    display="";
    telemetry="";
    tstamp="00:00:00";
    latD=0;
    lonD=0;
    bearing=0;
    distance=0;
    //titleBackClr

    /*+-------------------___________----------------------===========+*/

    String tail = aprsStringFormat;
    display = aprsStringFormat;
    //println("tail step 1: ",tail);
    tstamp = timestamp();
    if (!aprsStringFormat.contains(">")) return;
    //println(tail);
    // extract callsign//
    String[] arr = split(tail, '>');
    callsign = arr[0];
    //println("callsign",callsign);
    tail = tail.substring(arr[0].length()+1);
    //println("tail step 2: ",tail);
    //get the path
    arr = split(tail, ':');
    path = arr[0];
    //println("path= ",path, arr.length);
    tail = tail.substring(arr[0].length()+1);
    //println("tail step 3: ",tail);
    // get the mode
    mode = tail.substring(0, 1);
    //println("mode on exit>>   ",mode,"   <<");
    tail= tail.substring(1, tail.length());
    //println("tail before movin on: ",tail);
    if(tail.length() < 1) return;
    
    //println("update",tail, msgtext);
    // success to this point

    // what's left is the tail (based on mode) for now

    // oh dear <--
    switch(mode) {

    case ">":      // easy!
      status = tail;
      break;

    case "!":      // hard
      // 4236.83N/08257.28We .....
      // position with no timestamp
      lat = tail.substring(0, 8);
      latD = lat2ddd(lat);
      symL = tail.substring(8, 9);
      symR = tail.substring(17, 18);
      lon = tail.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      tail = tail.substring(18);
      status = "! pos w/o timestamp";
      display = tail;
      break;

    case "=":      // not so hard
      // 4236.83N/08257.28We .....
      // position with no timestamp
      lat = tail.substring(0, 8);
      latD = lat2ddd(lat);
      symL = tail.substring(8, 9);
      symR = tail.substring(17, 18);
      lon = tail.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      tail = tail.substring(18);
      status = "= pos w/o timestamp";
      display = tail;
      break;

    case "@":      // not so hard
      // 000000z4236.83N/08257.28We .....
      // position with timestamp
      // strip off time..
      if (tail.length() <1) return;
      tail = tail.substring(7);
      lat = tail.substring(0, 8);
      latD = lat2ddd(lat);
      symL = "/"; //tail.substring(8, 9); symR = "e"; //tail.substring(17, 20);  // ?
      lon = tail.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      tail = tail.substring(18);
      status = "@ pos with timestamp";
      display = tail;
      break;

    case "/":      // not so hard
      tail = tail.substring(7);
      lat = tail.substring(0, 8);
      latD = lat2ddd(lat);
      symL = "/"; //tail.substring(8, 9); symR = "e"; //tail.substring(17, 20);  // ?
      lon = tail.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      tail = tail.substring(20);
      status = "/ pos with timestamp";
      display = tail;
      break;

    case ":":      // hard
      //println("message",tail);
      status = "message ";
      // if i'm in the message, it's to me!
      if(tail.contains(my.callsign)) {
        // let user know?
        tail = "<>" + tail;
        // send an ack back
        //String[] s = tail.split("{");
        //String ack = s[s.length-1];
        //ack = "ack" + ack.substring(1);
        //sendMessage(callsign,ack);
      }
      display = tail;
      break;

    case "`":
      status = "mic-e ";
      display = tail;
      break;
    case ";":
      status = "object ";
      display = tail.substring(17,35);
      // convert spaces to zeros - omfg
      display = display.replace(" ","0");
      lat = display.substring(0, 8);
      latD = lat2ddd(lat);
      symL = "/"; //tail.substring(8, 9); symR = "e"; //tail.substring(17, 20);  // ?
      lon = display.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      display = tail.substring(35);
      
      //display = tail;
      break;
    case "<":
      status = "station capabilities ";
      display = tail;
      break;
    case "#":
      status = "peet bros weather";
      display = tail;
      break;
    case "$":
      status = "raw gps";
      display = tail;
      break;
    case "*":
      status = "peet bros weather";
      display = tail;
      break;
    case "_":
      status = "weather";
      display = tail;
      break;
    case "%":
      status = "microfinder";
      break;
    case "T":
      telemetry = tail;
      status = "telemetry ";
      display = tail;
      break;
    default:
      status = "- none";
      display = tail;
      break;
    }
  }

  /*+-------------------___________----------------------===========+*/
  //  void show(int x, int y) {
  public void show() {
    // ok
    // i want for now, a persistant overlay - maybe a text box?
    // just a rect with text for now
    pushMatrix();
    translate(x, y);

    //title bar (shadow)
    fill(shadowColour);
    fill(titleBack);
    rect(2, 2, w, h);

    //background rect
    fill(bodyBack);
    stroke(brdrColour);
    rect(0, 0, w, h);  // check

    //
    fill(24);
    rect(0, 0, 450, 20);
    // print the callsign
    textSize(28);
    fill(titleFore);
    text(callsign, 10, 20);

    // the time
    textSize(20);
    fill(220, 220, 10);
    text(tstamp, 300, 20);

    // print the path
    textSize(14);
    fill(255);
    text(path, 10, 45);

    textSize(14);
    if (mode == ":") {
      fill(0, 100, 255);
    } else {
      fill(255);
    }
    text(status, 10, 60);

    String old;
    old = display;
    if (display.length() > 50) {
      old = display.substring(50);
      display = display.substring(0, 49);
      text(display, 10, 85);
      //      println(display.length(), display);
      if (old.length() > 50) old = old.substring(0, 49);
      text(old, 10, 105);
    } else {
      text(display, 10, 85);
    }


    // icons and such
    if (distance > 0) {
      textSize(14);
      fill(255);
      text(nf(distance, 0, 1) + "km", 200, 17);
      image(loc_img, 170, 0, 22, 22);
    }

    popMatrix();
  }

  /*+-------------------___________----------------------===========+*/

  public float haversine(String la1, String lo1, String la2, String lo2) {
    // this will set two globals called 'latitude' and 'longitude'
    // good enough

    float R = 40075/TWO_PI;   // earth's circumference / two_pi
    float dla1 = lat2ddd(la1) / (180/PI);
    float dlo1 = lon2ddd(lo1) / (180/PI);
    float dla2 = lat2ddd(la2) / (180/PI);
    float dlo2 = lon2ddd(lo2) / (180/PI);
    float d = acos(sin(dla1) * sin(dla2) + cos(dla1) * cos(dla2) * cos(dlo2 - dlo1)) * R;
    //d = round(d *10000) / 10000;

    // bearing
    // θ = atan2( sin Δλ ⋅ cos φ2 , cos φ1 ⋅ sin φ2 − sin φ1 ⋅ cos φ2 ⋅ cos Δλ )
    // Δλ = dlon2 - dlon1
    //
    //
    bearing = atan2(sin(dlo2 - dlo1) * cos(dla2), cos(dla1) * sin(dla2) - sin(dla1) * cos(dla2) * cos(dlo2-dlo1)) * (90/PI);

    return d;
  }
}

/*+-------------------___________----------------------===========+*/

public float lon2ddd(String deg) {
  // this will be in 17959:99W format
  // returning -179.99999
  if (deg.length() < 9) {
    return 0;
  }
  float st;
  float pm = -1;
  float togo;
  float min2dec = 100.0f/60.0f;
  if (deg.substring(8) == "E") {
    pm=-pm;
  }
  float a = PApplet.parseFloat(deg.substring(0, 3));
  float b = round(PApplet.parseFloat(deg.substring(3, 5))*min2dec)*100;
  float c = PApplet.parseFloat(deg.substring(6, 8));
  togo = (a + ((b + c) / 10000) ) * pm;
  return togo;
}


public float lat2ddd(String deg) {
  // this will be in 8959:99W format
  // returning -89.99999
  if (deg.length() < 8) {
    return 0;
  }
  float pm = 1;
  float togo;
  float min2dec = 100.0f/60.0f;
  if (deg.substring(7) == "S") {
    pm=-pm;
  }
  float a = PApplet.parseFloat(deg.substring(0, 2));
  float b = round(PApplet.parseFloat(deg.substring(2, 4))*min2dec)*100;
  float c = PApplet.parseFloat(deg.substring(5, 7));
  togo = (a + ((b + c) / 10000) ) * pm;
  return togo;
}



///

//


  public void settings() { size(1150, 720); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "aprsClient" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
