/*
 ok, restart project
 
 we're going to use stringlists and that's that. screw arrays and arraylists
 - update i will probably use an ArrayList of objects :(
 
 in fact, what i *should* do is class by call-id/mode and make a list for each
 - maybe?
 
 eg
 VA3APW-1 T
 VA3APW-1 !
 in seperate lists
 
 OR
 
 i can just search through the history for the relevant entries (i like this)
 - like making a .csv better and using a spreadsheet
 
 
 */

import processing.net.*;
import processing.sound.*;
import controlP5.*;
ControlP5 cp5;
//Textarea myTextarea;

// globals
String version;
Client sock;
SinOsc snd;
SoundFile snd_file;
SoundFile meow;

int historyMax = 16383;
boolean CONNECTED = false;
String cr ="\r";
String lf ="\n";
String crlf = "\r\n";
int currentBcnPos = 0;

PImage loc_img;
PImage spkr_img;

String mybeacon = "VA3ODC D-Star/APRS - aprs-j ver0.01";
//Button but;
Button but = new Button(150, 40, "BEACON", color(255, 255, 0), color(25, 25, 150), 18);
Button select = new Button(150, 40, "Next->", color(255, 255, 0), color(25, 25, 150), 18);
Button edFavorites = new Button(100, 40, "Faves", color(255, 255, 0), color(25, 25, 150), 18);
Button edSetup = new Button(100, 40, "Setup", color(255, 255, 0), color(25, 25, 150), 18);
Button edBeacons = new Button(100, 40, "Beacons", color(255, 255, 0), color(25, 25, 150), 18);

Button butSaveHistory = new Button(100, 40, "Save H", color(255, 255, 0), color(25, 25, 150), 18);
Button butClearHistory = new Button(100, 40, "Clear H", color(255, 255, 0), color(25, 25, 150), 18);

class MyStuff {
  //server et al stuff
  String callsign;
  String id;
  String pass;
  String login;
  String filter;
  // position (aprs_text and decimal - you do the math)
  String lat;
  String lon;
  float latD;
  float lonD;
  // beaconing info (seperate from beacons.txt)
  String beacon;
  int bcnTimeout;

  String symbol;
  String sL, sR;
}
MyStuff my = new MyStuff();

String lastBeacon = "";
String nextBeacon = "";

StringList history = new StringList();
StringList favourites = new StringList();
StringList lastFav = new StringList();

StringList beacons = new StringList();

//AprsObject packet = new AprsObject("");

AprsObject current = new AprsObject("MARTEN");
AprsObject[] last = new AprsObject[6];
AprsObject[] temp = new AprsObject[7];


//ArrayList<AprsObject> records = new ArrayList<AprsObject>();

String url1, url2;

PFont font;

void setup() {
  //windowResizable(true);
  //frame.setResizable(true);
  //surface.setResizable(true);

  size(1150, 720);
  background(0, 0, 30);
  
  PFont font;
  font = createFont("Courier New", 14);
  textFont(font, 16);

  //--------------------------------------------------------------------------------------------------------------
  cp5 = new ControlP5(this);
  cp5.addTextfield("callsign").setPosition(80, 290).setSize(90, 30).setFont(font).setAutoClear(false);
  cp5.addTextfield("message").setPosition(180, 290).setSize(250, 30).setFont(font).setAutoClear(false);
  cp5.addBang("Send").setPosition(450, 290).setSize(60, 30);

  history = new StringList();
  favourites = new StringList();
  // ok, here we go
  background(0);
  fill(255);
  textSize(48);
  text("loading user...", 300, width/2);
  loadUserParams();
  background(0);
  text("loading favourites...", 300, width/2);
  my.beacon = my.callsign + "-" + my.id + ">APMI06,TCPIP*,qAS," + my.callsign + ":=" +my.lat + my.sL + my.lon + my.sR;

  loadFavourites();
  background(0);
  text("loading beacons...", 300, width/2);
  loadBeacons();


  snd = new SinOsc(this);
  snd_file = new SoundFile(this, "dun-dun.mp3");
  snd_file.amp(0.5);
  meow = new SoundFile(this, "meow.mp3");
  meow.amp(0.3);


  textSize(16);

  // last N history objects
  for (int k=0; k < last.length; k++) {
    last[k] = new AprsObject("hello " + k);
    last[k].update("N1KK0-10>path:>status");
    last[k].x = 700;
    last[k].y = (k-1) * 200+20;
  }

  // last 4 history objects
  for (int m=0; m < 5; m++) {
    temp[m] = new AprsObject("hello " + m);
    temp[m].update("MARTEN-10>path:>cool status");
    temp[m].x = 700;
    temp[m].y = (m-1) * 200 +20;
  }

  current.update("NIKKO>pathway:>status");

  loc_img = loadImage("location-80.png");
  spkr_img = loadImage("speaker.png");

  nextBeacon = beacons.get(int(random(beacons.size())));

  fill(255);
  textSize(48);
  background(0);
  text("connecting...", 200, 600);

  // ------------ do it!
  sockConnect();
  // ------------

  //
}

void Send() {
  print("the following text was submitted :");
  url1 = cp5.get(Textfield.class, "callsign").getText();
  url2 = cp5.get(Textfield.class, "message").getText();

  sendMessage(url1, url2);
}

void showRecord(AprsObject rec) {
  rec.show();
}

void draw() {
  //background(30, 0, 0);
  String data;
  snd.stop();
  current.show();
  
  if (CONNECTED) {
    showTime();
    current.show();
    // get a string
    if (sock.available() > 0) { // If there's incoming data from the client...
      data = sock.readString(); // grab it and append to history (eventually)
      if (data.indexOf("#") == 0) return;  // server message - ignore

      // split into sep strings
      String[] t = split(data, crlf);

      // loop through all the incoming in case there's a burst (which are many)
      // MAIN LOOP
      for (int i=0; i<t.length; i++) if (t[i].length() >0) {
        // do for all
        AprsObject packet = new AprsObject(t[i]);
        packet.update(t[i]);
        
        // might work? (does)
        current = packet;
        
        // update winTitle
        windowTitle(packet.callsign);

        // print current time
        showTime();

        // update history
        history.append(timestamp() + " " + t[i]);

        // display incoming packet
        packet.x = 30;
        packet.y = 20;
        packet.show();

        // see if it's in the list
        if (inList(parseCall(t[i]))) {
          showTime();

          // if it's in the callsign watch list...
          packet.update(t[i]);
          packet.x = 30;
          packet.y = 20;
          packet.show();

          // bump them
          for (int j=last.length-2; j>=0; j--) last[j+1] = last[j];
          last[0] = packet;
          
        }
        // not in list show anyway
        packet.x = 30;
        packet.y = 20;
        packet.show();
        showTime();

      }
    }
  }

  // clear screen - draw everything
  background(30, 0, 0);
  
  // print something as a place holder
  textSize(40);
  text("va3odc.com",100,80);
  
  printHistory();
  
  current.show();
  
  // show the last N matching packets :)
  for (int k=0; k<last.length; k++) {
    last[k].x = 700;
    last[k].y = k*last[k].h;
    last[k].show();
  }

  showButtons();

  select.show(30, 160);
  // print nextBeacon
  fill(170);
  text(nextBeacon, 200, 190);
  // beacon button
  but.show(30, 205);
  // print lastBeacos
  fill(170);
  text("last bcn: " + lastBeacon, 30, 275);

  text("msg: ", 30, 310);
  
  // ------------------------------------------------------------------------------------------------------------------------------
  // print current time
  showTime();
}
  
void showButtons() {
  edFavorites.show(30, 660);
  edBeacons.show(150, 660);
  edSetup.show(270, 660);
  butSaveHistory.show(390, 660);
  butClearHistory.show(510, 660);
  
  textSize(14);
  fill(150, 150, 10);
  text("changes require restart!", 110, 718);
}

//void mouseMoved() {
//  showButtons();
//}

void mouseClicked() {
  if (but.hover()) beaconNow("");
  if (select.hover()) randomBeaconSelect();
  if (edFavorites.hover()) openNotepad("callsigns.txt");
  if (edBeacons.hover()) openNotepad("beacons.txt");
  if (edSetup.hover()) openNotepad("setup.txt");

  if (butClearHistory.hover()) history.clear();
  if (butSaveHistory.hover()) { 
    String[] stringArray = history.toArray(new String[history.size()]);
    saveStrings("history.txt",stringArray);
    history.append("-------- ===== >> DATA SAVED in history.txt << ======= ---------");
  }
  
}

void openNotepad(String filename) {
  // open notepad.exe with filename.txt
  String callFile = sketchPath() + "/" + filename;
  String a = "notepad.exe " + callFile;
  launch(a);
}

void randomBeaconSelect() {
  currentBcnPos++;
  if(currentBcnPos > beacons.size()-1) currentBcnPos = 0;
  //nextBeacon = beacons.get(int(random(beacons.size())));
  nextBeacon = beacons.get(currentBcnPos);
}

String timestamp() {
  return nf(hour(), 2) +":"+ nf(minute(), 2) +":"+ nf(second(), 2) + " ";
}

void showTime() {
  fill(60);
  rect(520, 85, 120, 20);
  fill(255);
  textSize(20);
  text(timestamp(), 530, 100);
}

void loadUserParams() {
  // get info saved in setup.txt
  String[] lines = loadStrings("setup.txt");
  my.callsign = lines[0];
  my.id = lines[1];
  my.pass = lines[2];
  my.filter = lines[3];
  my.bcnTimeout =int(lines[4]);
  my.lat = lines[5];
  my.lon = lines[6];
  my.latD = float(lines[7]);
  my.lonD = float(lines[8]);
  my.symbol = lines[9];
  my.sL = my.symbol.substring(0, 1);
  my.sR = my.symbol.substring(1, 2);
  my.login = "user " + my.callsign + "-" + my.id + " pass " + my.pass + " ver APRSdashboard 0.04 filter " + my.filter;


  //println(lines.length, "user params loaded.");
}

void loadFavourites() {
  // get the favourites from callsigns.txt
  String[] lines = loadStrings("callsigns.txt");
  favourites.clear();
  for (int i = 0; i < lines.length; i++) {
    favourites.append(lines[i]);
  }
  //println(lines.length, "favourites loaded.");
}

void loadBeacons() {
  // get the beacons from beacons.txt
  //beacons.clear();
  String[] lines = loadStrings("beacons.txt");
  //println("# lines= ", lines.length);
  for (int i = 0; i < lines.length; i++) {
    //println(i, lines[i]);
    beacons.append(lines[i]);
  }
  //println(lines.length, "beacons loaded.");
}

boolean inList(String call) {
  // loop through favourites
  if (call != null) {
    for (int i=0; i < favourites.size(); i++) {
      String g = favourites.get(i);
      if (call.contains(g)) return true;
    }
  }
  return false;
}


void sockConnect() {
  // Connect to APRS server on port 14580
  sock = new Client(this, "euro.aprs2.net", 14580);
  // send this to IS to get started
  sock.write(my.login + crlf);
  // we'll assume it worked out... lol
  CONNECTED = true;
}

void printHistory() {
  //int m=0;if(m == 0) return;
  StringList temp;
  temp = new StringList();
  int hsize = history.size();

  // get the last # lines depending on screen height
  int numlines = 20; //height/20-3;
  if (hsize<numlines) numlines = hsize;

  // get them from history backwards
  //println("hsize",hsize,"history.size()",history.size());
  for (int i=hsize-1; i>=hsize-numlines; i--) temp.append(history.get(i));

  fill(255, 255, 0);
  textSize(20);
  text("history " + history.size(), 20, 380);
  textSize(12);

  // show them
  pushMatrix();
  translate(10, 400);
  float fadespeed = 15;
  String dt;
  for (int k=0; k<temp.size(); k++) {
    dt = temp.get(k);
    fill(250- k*fadespeed);
    if (inList(parseCall(dt))) {
      fill(0, 255, 0);
    }
    text(dt, 0, 18*k);
  }
  fill(0);
  popMatrix();
  
  if (hsize >= historyMax) history.remove(0);

}

String parseCall(String d) {
  String[] arr = split(d, '>');
  String H = arr[0];
  return H;
}

void sendMessage(String call, String msg) {
  println("Beacon", call, msg);

  if (CONNECTED) {
    if(call.length() < 4) return;
    if(msg.length() < 1) msg = "<->";
    String cs = call.toUpperCase();
    String bacon = my.callsign + "-" + my.id + ">APMI06,TCPIP*,qAS," + my.callsign + "::";
    cs = cs + "          ";
    cs = cs.substring(0, 9);
    String ack = "{" + str(int(random(10000, 99999)));
    bacon = bacon + cs + ":" + msg + ack;

    sock.write(bacon + crlf);
  }
}


void beaconNow(String txt) {
  String bcn;
  if (CONNECTED) {
    if (nextBeacon.length() < 1) bcn = beacons.get(int(random(beacons.size())));

    // my.beacon = my.callsign + "-" + my.id + ">APMI06,TCPIP*,qAS," + my.callsign + ":=" +my.lat + my.sL + my.lon + my.sR;

    bcn = nextBeacon;
    sock.write(my.beacon + bcn + crlf);

    lastBeacon = timestamp() + " " + bcn;
    //nextBeacon = beacons.get(int(random(beacons.size())));
  }
}


////

////

//
