/*

 oh boy!
 
 */


class AprsObject {
  String callsign, id, path, mode, tail, symL, symR, lat, lon, status, msgtext;
  float latD, lonD, bearing, distance;
  String telemetry;
  String tstamp;
  String tag;

  int x, y;
  int w = 450;
  int h = 120;

  String display;

  color titleBack, titleFore, bodyBack, bodyFore, brdrColour, shadowColour;
  ;
  color clr = color(100, 26, 179);

  /*+-------------------___________----------------------===========+*/

  AprsObject(String t) {
    //data = arg;
    String txt = t;
    //makeRecord(t);
    brdrColour = color(144);
    brdrColour = color(0);
    bodyBack = color(0);
    bodyFore = color(255);
    titleBack = color(60, 70, 80);
    titleFore = color(255, 255, 255);
    shadowColour = color(60, 70, 80, 100);
    display = "ve3ugg.com catsrus.ca";
  }

  void update(String aprsStringFormat) {
    // the meat and potatoes
    // arrgg...

    //reset all the variables
    callsign ="";
    id="";
    path="";
    mode="";
    tail="";
    symL="";
    symR="";
    lat="";
    lon="";
    status="";
    display="";
    telemetry="";
    tstamp="00:00:00";
    latD=0;
    lonD=0;
    bearing=0;
    distance=0;
    //titleBackClr

    /*+-------------------___________----------------------===========+*/

    String tail = aprsStringFormat;
    display = aprsStringFormat;
    //println("tail step 1: ",tail);
    tstamp = timestamp();
    if (!aprsStringFormat.contains(">")) return;
    //println(tail);
    // extract callsign//
    String[] arr = split(tail, '>');
    callsign = arr[0];
    //println("callsign",callsign);
    tail = tail.substring(arr[0].length()+1);
    //println("tail step 2: ",tail);
    //get the path
    arr = split(tail, ':');
    path = arr[0];
    //println("path= ",path, arr.length);
    tail = tail.substring(arr[0].length()+1);
    //println("tail step 3: ",tail);
    // get the mode
    mode = tail.substring(0, 1);
    //println("mode on exit>>   ",mode,"   <<");
    tail= tail.substring(1, tail.length());
    //println("tail before movin on: ",tail);
    if(tail.length() < 1) return;
    
    //println("update",tail, msgtext);
    // success to this point

    // what's left is the tail (based on mode) for now

    // oh dear <--
    switch(mode) {

    case ">":      // easy!
      status = tail;
      break;

    case "!":      // hard
      // 4236.83N/08257.28We .....
      // position with no timestamp
      lat = tail.substring(0, 8);
      latD = lat2ddd(lat);
      symL = tail.substring(8, 9);
      symR = tail.substring(17, 18);
      lon = tail.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      tail = tail.substring(18);
      status = "! pos w/o timestamp";
      display = tail;
      break;

    case "=":      // not so hard
      // 4236.83N/08257.28We .....
      // position with no timestamp
      lat = tail.substring(0, 8);
      latD = lat2ddd(lat);
      symL = tail.substring(8, 9);
      symR = tail.substring(17, 18);
      lon = tail.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      tail = tail.substring(18);
      status = "= pos w/o timestamp";
      display = tail;
      break;

    case "@":      // not so hard
      // 000000z4236.83N/08257.28We .....
      // position with timestamp
      // strip off time..
      if (tail.length() <1) return;
      tail = tail.substring(7);
      lat = tail.substring(0, 8);
      latD = lat2ddd(lat);
      symL = "/"; //tail.substring(8, 9); symR = "e"; //tail.substring(17, 20);  // ?
      lon = tail.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      tail = tail.substring(18);
      status = "@ pos with timestamp";
      display = tail;
      break;

    case "/":      // not so hard
      tail = tail.substring(7);
      lat = tail.substring(0, 8);
      latD = lat2ddd(lat);
      symL = "/"; //tail.substring(8, 9); symR = "e"; //tail.substring(17, 20);  // ?
      lon = tail.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      tail = tail.substring(20);
      status = "/ pos with timestamp";
      display = tail;
      break;

    case ":":      // hard
      //println("message",tail);
      status = "message ";
      // if i'm in the message, it's to me!
      if(tail.contains(my.callsign)) {
        // let user know?
        tail = "<>" + tail;
        // send an ack back
        //String[] s = tail.split("{");
        //String ack = s[s.length-1];
        //ack = "ack" + ack.substring(1);
        //sendMessage(callsign,ack);
      }
      display = tail;
      break;

    case "`":
      status = "mic-e ";
      display = tail;
      break;
    case ";":
      status = "object ";
      display = tail.substring(17,35);
      // convert spaces to zeros - omfg
      display = display.replace(" ","0");
      lat = display.substring(0, 8);
      latD = lat2ddd(lat);
      symL = "/"; //tail.substring(8, 9); symR = "e"; //tail.substring(17, 20);  // ?
      lon = display.substring(9, 18);
      lonD = lon2ddd(lon);
      distance = haversine(lat, lon, my.lat, my.lon);
      display = tail.substring(35);
      
      //display = tail;
      break;
    case "<":
      status = "station capabilities ";
      display = tail;
      break;
    case "#":
      status = "peet bros weather";
      display = tail;
      break;
    case "$":
      status = "raw gps";
      display = tail;
      break;
    case "*":
      status = "peet bros weather";
      display = tail;
      break;
    case "_":
      status = "weather";
      display = tail;
      break;
    case "%":
      status = "microfinder";
      break;
    case "T":
      telemetry = tail;
      status = "telemetry ";
      display = tail;
      break;
    default:
      status = "- none";
      display = tail;
      break;
    }
  }

  /*+-------------------___________----------------------===========+*/
  //  void show(int x, int y) {
  void show() {
    // ok
    // i want for now, a persistant overlay - maybe a text box?
    // just a rect with text for now
    pushMatrix();
    translate(x, y);

    //title bar (shadow)
    fill(shadowColour);
    fill(titleBack);
    rect(2, 2, w, h);

    //background rect
    fill(bodyBack);
    stroke(brdrColour);
    rect(0, 0, w, h);  // check

    //
    fill(24);
    rect(0, 0, 450, 20);
    // print the callsign
    textSize(28);
    fill(titleFore);
    text(callsign, 10, 20);

    // the time
    textSize(20);
    fill(220, 220, 10);
    text(tstamp, 300, 20);

    // print the path
    textSize(14);
    fill(255);
    text(path, 10, 45);

    textSize(14);
    if (mode == ":") {
      fill(0, 100, 255);
    } else {
      fill(255);
    }
    text(status, 10, 60);

    String old;
    old = display;
    if (display.length() > 50) {
      old = display.substring(50);
      display = display.substring(0, 49);
      text(display, 10, 85);
      //      println(display.length(), display);
      if (old.length() > 50) old = old.substring(0, 49);
      text(old, 10, 105);
    } else {
      text(display, 10, 85);
    }


    // icons and such
    if (distance > 0) {
      textSize(14);
      fill(255);
      text(nf(distance, 0, 1) + "km", 200, 17);
      image(loc_img, 170, 0, 22, 22);
    }

    popMatrix();
  }

  /*+-------------------___________----------------------===========+*/

  float haversine(String la1, String lo1, String la2, String lo2) {
    // this will set two globals called 'latitude' and 'longitude'
    // good enough

    float R = 40075/TWO_PI;   // earth's circumference / two_pi
    float dla1 = lat2ddd(la1) / (180/PI);
    float dlo1 = lon2ddd(lo1) / (180/PI);
    float dla2 = lat2ddd(la2) / (180/PI);
    float dlo2 = lon2ddd(lo2) / (180/PI);
    float d = acos(sin(dla1) * sin(dla2) + cos(dla1) * cos(dla2) * cos(dlo2 - dlo1)) * R;
    //d = round(d *10000) / 10000;

    // bearing
    // θ = atan2( sin Δλ ⋅ cos φ2 , cos φ1 ⋅ sin φ2 − sin φ1 ⋅ cos φ2 ⋅ cos Δλ )
    // Δλ = dlon2 - dlon1
    //
    //
    bearing = atan2(sin(dlo2 - dlo1) * cos(dla2), cos(dla1) * sin(dla2) - sin(dla1) * cos(dla2) * cos(dlo2-dlo1)) * (90/PI);

    return d;
  }
}

/*+-------------------___________----------------------===========+*/

float lon2ddd(String deg) {
  // this will be in 17959:99W format
  // returning -179.99999
  if (deg.length() < 9) {
    return 0;
  }
  float st;
  float pm = -1;
  float togo;
  float min2dec = 100.0/60.0;
  if (deg.substring(8) == "E") {
    pm=-pm;
  }
  float a = float(deg.substring(0, 3));
  float b = round(float(deg.substring(3, 5))*min2dec)*100;
  float c = float(deg.substring(6, 8));
  togo = (a + ((b + c) / 10000) ) * pm;
  return togo;
}


float lat2ddd(String deg) {
  // this will be in 8959:99W format
  // returning -89.99999
  if (deg.length() < 8) {
    return 0;
  }
  float pm = 1;
  float togo;
  float min2dec = 100.0/60.0;
  if (deg.substring(7) == "S") {
    pm=-pm;
  }
  float a = float(deg.substring(0, 2));
  float b = round(float(deg.substring(2, 4))*min2dec)*100;
  float c = float(deg.substring(5, 7));
  togo = (a + ((b + c) / 10000) ) * pm;
  return togo;
}



///

//
